

let video;
let faceMesh;
let faces = [];
let triangles;
let uvCoords;
let img;

function preload() {
  faceMesh = ml5.faceMesh({ maxFaces: 1 });
  img = loadImage("mm.png");
}

function mousePressed() {
  console.log(faces);
}

function gotFaces(results) {
  faces = results;
}

function setup() {
  createCanvas(640, 480, WEBGL);

  video = createCapture(VIDEO);
  video.size(640, 480);
  video.hide();

  faceMesh.detectStart(video, gotFaces);

  triangles = faceMesh.getTriangles();
  uvCoords = faceMesh.getUVCoords();
}

function draw() {
  background(0);

  translate(-width/2, -height/2);

  if (faces.length > 0) {
    let face = faces[0];


    texture(img);
    textureMode(NORMAL);
    noStroke();
    beginShape(TRIANGLES);

    for (let i = 0; i < triangles.length; i++) {
      let [a, b, c] = triangles[i];

      let pA = face.keypoints[a];
      let pB = face.keypoints[b];
      let pC = face.keypoints[c];

      let uvA = uvCoords[a];
      let uvB = uvCoords[b];
      let uvC = uvCoords[c];

      vertex(pA.x, pA.y, uvA[0], uvA[1]);
      vertex(pB.x, pB.y, uvB[0], uvB[1]);
      vertex(pC.x, pC.y, uvC[0], uvC[1]);
    }

    endShape();

  

    let nose = face.keypoints[1];

    let cx = nose.x;
    let cy = nose.y - 120; 
    let cz = -80;

    let colors = [
      [80,140,255],   
      [255,220,90],   
      [255,70,70],    
      [180,120,255]   
    ];


    let count = 12;
    let radius = 90;
    
    for (let i = 0; i < count; i++) {
      let angle = frameCount * 0.01 + i * (TWO_PI / count);
      
      
      let hx = cx + cos(angle) * radius;
      let hy = cy + sin(angle) * 35; 
      let hz = cz + sin(angle * 2) * 20; 

    
      let col = colors[i % 4];

      drawHeart(hx, hy, hz, col, 1.0, 8);
    }
  }
}


function drawHeart(x, y, z, col, s, depth) {
  push();

  translate(x, y, z);  
  rotateY(frameCount * 0.03);

  scale(s);

  fill(col[0], col[1], col[2]);
  noStroke();

  let frontZ = depth / 2;
  let backZ = -depth / 2;

  
  beginShape();
  for (let t = 0; t < TWO_PI; t += 0.12) {
    let hx = 16 * pow(sin(t), 3);
    let hy = -(13*cos(t) - 5*cos(2*t) - 2*cos(3*t) - cos(4*t));
    vertex(hx, hy, frontZ);
  }
  endShape(CLOSE);

 
  beginShape();
  for (let t = 0; t < TWO_PI; t += 0.12) {
    let hx = 16 * pow(sin(t), 3);
    let hy = -(13*cos(t) - 5*cos(2*t) - 2*cos(3*t) - cos(4*t));
    vertex(hx, hy, backZ);
  }
  endShape(CLOSE);

 
  beginShape(QUADS);

  let prevX = null, prevY = null;

  for (let t = 0; t <= TWO_PI + 0.12; t += 0.12) {
    let hx = 16 * pow(sin(t), 3);
    let hy = -(13*cos(t) - 5*cos(2*t) - 2*cos(3*t) - cos(4*t));

    if (prevX !== null) {
      vertex(prevX, prevY, frontZ);
      vertex(prevX, prevY, backZ);
      vertex(hx, hy, backZ);
      vertex(hx, hy, frontZ);
    }

    prevX = hx;
    prevY = hy;
  }

  endShape(CLOSE);

  pop();
}
